:- module(playerChoices,[selectPlayer/3]).

:- use_module(library(random)).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% TURN-MAKING, controlling whether the Proponent or Opponent are allowed to act next       %%%
%%% First two args: input P and O ... third arg: output binary decision			     %%%
%%% We know that it is never the case that both P and O are empty (executeAB catches that)   %%%
%%% We also guarantee that the chosen play is non-empty!				     %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

selectPlayer(P,O,Result)	:-
		user:player_choice(X),
		selectionMethod(X,P,O,Result).

%%% Simple selection method: choose from P as long as P is non-empty, else from O 
selectionMethod(1,[_|_],_,selectFromP).
selectionMethod(1,[],_,selectFromO). 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% ALTERNATIVE 2 - always prefer opponent
selectionMethod(2,_,[_|_],selectFromO).
selectionMethod(2,_,[],selectFromP). 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% ALTERNATIVE 3 - alternate
selectionMethod(3,_,[],selectFromP):- retractall(last_turn(_)), assert(last_turn(fromP)). 
selectionMethod(3,[],_,selectFromO):- retractall(last_turn(_)), assert(last_turn(fromO)).
selectionMethod(3,_,_,selectFromP) :- last_turn(fromO), retractall(last_turn(_)), assert(last_turn(fromP)). 
selectionMethod(3,_,_,selectFromO) :- last_turn(fromP), retractall(last_turn(_)), assert(last_turn(fromO)). 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% ALTERNATIVE 4 - random
selectionMethod(4,_,[],selectFromP). 
selectionMethod(4,[],_,selectFromO).
selectionMethod(4,_,_,X) :- random(Num), chooseRandomPlayer(Num,X).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

chooseRandomPlayer(Num, selectFromP) :- Num < 0.5.
chooseRandomPlayer(Num, selectFromO) :- Num >= 0.5.
